/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.IVWTaskManager;
import filenet.vw.apps.taskman.VWTaskApplicationSettings;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.images.VWImageLoader;
import filenet.vw.apps.taskman.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.sysutils.VWRegistryTool;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.IVWSplashWindowListener;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWLoadingWindow;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class VWTaskManager
extends JFrame
implements IVWTaskManager,
IVWFrameInterface,
IVWSplashWindowListener {
    private int m_registryPort;
    private final int s_appWidth = 800;
    private final int s_appHeight = 600;
    private transient VWTaskApplicationSettings m_appSettings = null;
    private static final String SERVICE_NAME = "TaskManager";

    public VWTaskManager(VWTaskApplicationSettings appSettings) throws Exception {
        String helpBase;
        this.m_appSettings = appSettings;
        System.out.println("Loading Process Task Manager");
        if (appSettings.getProperties().getBoolean("TaskManager.ConsolidatedView")) {
            this.m_registryPort = this.m_appSettings.getApplicationRegistryPort();
            try {
                IVWTaskManager tm = (IVWTaskManager)LocateRegistry.getRegistry(this.m_registryPort).lookup(SERVICE_NAME);
                tm.ping();
                VWTaskCore.getInstance().displayInformation(VWResource.ProcessTaskManagerAlreadyRunning);
                tm.showApplication();
                VWDebug.logInfo("A Task Manager instance is already running is consolidated view mode, this instance will exit.");
                System.exit(1);
            }
            catch (Exception ex) {
                try {
                    VWDebug.logInfo("Registering Task Manager in the rmi registry.");
                    UnicastRemoteObject.exportObject(this);
                    VWRegistryTool.rebind(SERVICE_NAME, this, this.m_registryPort);
                }
                catch (Exception ex2) {
                    VWDebug.logException(ex2, "Unable to bind the Task Manager UI to the rmi registry.");
                }
            }
        }
        if ((helpBase = System.getProperty("WF_HELP", "")).endsWith("/pe_help")) {
            helpBase = helpBase.substring(0, helpBase.indexOf("/pe_help"));
            System.setProperty("WF_HELP", helpBase);
        }
        VWHelp.init(this);
        this.setTitle(VWResource.ProcessTaskManager);
        ImageIcon icon = VWImageLoader.createImageIcon("initfnsw_3d_16.gif");
        if (icon != null && icon.getImage() != null) {
            this.setIconImage(icon.getImage());
        }
        this.addWindowListener(new VWWindowAdapter(this));
        this.updatePosition(800, 600);
        this.show();
        VWLoadingWindow loadingWindow = new VWLoadingWindow((Frame)this, this.getTitle());
        loadingWindow.start(this, 1000);
    }

    public void ping() throws RemoteException {
    }

    public void showApplication() throws RemoteException {
        this.show();
        this.toFront();
    }

    public Vector getProperties() throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public boolean getLoggingState() throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public void setLoggingState(boolean logState) throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public boolean getTracingState() throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public void setTracingState(boolean state) throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public void windowClosing(WindowEvent event) {
        if (event == null) {
            return;
        }
        if (event.getSource() == this) {
            this.setVisible(false);
            try {
                VWRegistryTool.unbind(SERVICE_NAME, this.m_registryPort);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dispose();
            System.exit(0);
        }
    }

    public void startProcessing() {
        try {
            VWTaskCore.getInstance().init(this, this.m_appSettings, false);
            this.performInitialRefresh();
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            VWDebug.logError(sw.toString());
        }
    }

    private void performInitialRefresh() {
        try {
            Locale locale = Locale.getDefault();
            if (locale != null) {
                ComponentOrientation compOrientation = ComponentOrientation.getOrientation(locale);
                VWTaskManager appFrame = this;
                if (appFrame != null && compOrientation != null) {
                    appFrame.applyComponentOrientation(compOrientation);
                    Window[] windows = appFrame.getOwnedWindows();
                    if (windows != null) {
                        for (int j = 0; j < windows.length; ++j) {
                            windows[j].applyComponentOrientation(compOrientation);
                        }
                    }
                    appFrame.setPreferredSize(appFrame.getSize());
                    appFrame.pack();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    private void updatePosition(int nAppWidth, int nAppHeight) {
        Point location;
        this.setSize(nAppWidth, nAppHeight);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension appSize = this.getSize();
        if (screenSize.width > appSize.width) {
            location = this.getLocation();
            this.setLocation((screenSize.width - appSize.width) / 2, location.y);
        }
        if (screenSize.height > appSize.height) {
            location = this.getLocation();
            this.setLocation(location.x, (screenSize.height - appSize.height) / 2);
        }
    }
}

